/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanTMoc;
import cds.aladin.Position;
import cds.moc.TMoc;
import cds.tools.Util;
import java.util.Iterator;

public class PlanTMocGen
extends PlanTMoc {
    private Plan[] p;
    private double duration;
    private int order;
    private double gapPourcent;

    protected PlanTMocGen(Aladin aladin, String label, Plan[] p, int order, double duration) {
        super(aladin, (MyInputStream)null, label, null);
        this.c = null;
        this.p = p;
        this.order = order;
        this.duration = duration;
        this.pourcent = 0.0;
        this.gapPourcent = 100 / p.length;
        this.suiteSpecific();
        this.threading();
        this.log();
    }

    @Override
    protected void launchLoading() {
    }

    private void addMocFromCatalog(TMoc moc, Plan p1, double duration) {
        long t0 = System.currentTimeMillis();
        Iterator<Obj> it = p1.iterator();
        int m = p1.getCounts();
        double incrPourcent = this.gapPourcent / (double)m;
        moc.clear();
        moc.bufferOn(10000);
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Position)) continue;
            if (m < 100) {
                this.pourcent += incrPourcent;
            }
            try {
                double jdtime = ((Position)o).jdtime;
                if (Double.isNaN(jdtime)) continue;
                moc.add(jdtime, jdtime + duration / 86400.0);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
        moc.bufferOff();
        long t1 = System.currentTimeMillis();
        Aladin.trace(4, "TMOC created in " + Util.getTemps((t1 - t0) * 1000L) + " (" + m + " sources)");
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.moc = new TMoc();
            if (this.order != -1) {
                ((TMoc)this.moc).setMocOrder(this.order);
            }
            for (Plan p1 : this.p) {
                if (!p1.isCatalogTime()) continue;
                if (this.c == null) {
                    this.c = p1.c.darker();
                }
                this.addMocFromCatalog((TMoc)this.moc, p1, this.duration);
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.flagProcessing = false;
            return false;
        }
        this.flagProcessing = false;
        this.flagOk = true;
        return true;
    }
}

